# YouText - YouTube Subtitle Extractor

YouText is a web application that allows users to extract subtitles from YouTube videos and save them as text or SRT files. It uses open-source tools to extract subtitles without requiring any API keys or authentication.

## Features

- Extract subtitles from any YouTube video that has them available
- Support for multiple languages
- Download subtitles in plain text or SRT format (with timestamps)
- Copy subtitles to clipboard
- Simple and responsive user interface

## Technologies Used

- **Backend**: Python with Flask
- **Subtitle Extraction**: youtube-transcript-api and yt-dlp
- **Frontend**: HTML, CSS, JavaScript

## Installation

### Local Development

1. Clone the repository:
   ```
   git clone https://github.com/yourusername/youtext.git
   cd youtext
   ```

2. Create a virtual environment and activate it:
   ```
   python3 -m venv venv
   source venv/bin/activate  # On Windows: venv\Scripts\activate
   ```

3. Install the dependencies:
   ```
   pip install -r requirements.txt
   ```

4. Run the application:
   ```
   python app.py
   ```

5. Open your browser and navigate to `http://localhost:8080`

### Hosting on Fastcomet

For detailed instructions on hosting this application on Fastcomet, please refer to the `HOSTING_GUIDE.md` file.

**Important Note**: YouTube's anti-bot measures are more strictly enforced for server-side requests. To use this application on a server, you must set up YouTube cookies as described in `YOUTUBE_COOKIES_GUIDE.md`.

## How It Works

1. The application uses `youtube-transcript-api` as the primary method to extract subtitles
2. If that fails, it falls back to `yt-dlp` which can handle more complex cases
3. The extracted subtitles can be formatted as plain text or SRT (with timestamps)
4. Users can download the subtitles as a file or copy them to the clipboard

## License

Copyright © 2025 Contenjoo

This project is licensed under the MIT License - see the LICENSE file for details.

## Acknowledgements

- [youtube-transcript-api](https://github.com/jdepoix/youtube-transcript-api)
- [yt-dlp](https://github.com/yt-dlp/yt-dlp)
- [Flask](https://flask.palletsprojects.com/)
