#!/bin/bash

# YouTube 자막 추출 서버 실행 스크립트 (호스팅 환경용)

# 현재 디렉토리로 이동
cd "$(dirname "$0")"

# 환경 변수 설정
export PYTHONIOENCODING=utf-8
export FLASK_APP=app.py

# 쿠키 파일 확인
COOKIES_FILE="youtube_cookies.txt"
if [ ! -f "$COOKIES_FILE" ]; then
    echo "Warning: YouTube cookies file not found. Please create it according to YOUTUBE_COOKIES_GUIDE.md"
else
    # 쿠키 파일의 줄 수 확인
    COOKIE_LINES=$(grep -v "^#" "$COOKIES_FILE" | wc -l)
    if [ "$COOKIE_LINES" -lt 2 ]; then
        echo "Warning: YouTube cookies file seems empty or invalid. Please update it according to YOUTUBE_COOKIES_GUIDE.md"
    else
        echo "YouTube cookies file found with $COOKIE_LINES entries"
    fi
fi

# 디렉토리 권한 설정
CACHE_DIR="cache"
LOGS_DIR="logs"

# 캐시 디렉토리 생성
if [ ! -d "$CACHE_DIR" ]; then
    mkdir -p "$CACHE_DIR"
    echo "Created cache directory"
fi
chmod -R 755 "$CACHE_DIR"

# 로그 디렉토리 생성
if [ ! -d "$LOGS_DIR" ]; then
    mkdir -p "$LOGS_DIR"
    echo "Created logs directory"
fi
chmod -R 755 "$LOGS_DIR"

# SSL 인증서 경로 확인
if [ -f "/etc/ssl/certs/ca-certificates.crt" ]; then
    export SSL_CERT_FILE="/etc/ssl/certs/ca-certificates.crt"
    export REQUESTS_CA_BUNDLE="/etc/ssl/certs/ca-certificates.crt"
    echo "Using system SSL certificates"
fi

# 서버 실행
echo "Starting YouTube subtitle extractor server..."
echo "$(date): Server started" >> "$LOGS_DIR/server.log"

# 호스팅 환경에 맞게 실행
python3 app.py --sleep-requests 3 --min-sleep-interval 60 --max-sleep-interval 120 2>&1 | tee -a "$LOGS_DIR/server.log"
