# Fastcomet 호스팅 서버 설치 가이드

이 가이드는 YouTube 자막 추출 애플리케이션을 Fastcomet 호스팅 서버에 설치하고 실행하는 방법을 설명합니다.

## 로컬과 서버 환경의 차이점

Fastcomet에 따르면, 로컬에서 작동하는 애플리케이션이 서버에서 작동하지 않는 주요 원인은 YouTube의 봇 방지 조치 때문입니다:

- 서버 IP는 YouTube에 의해 봇으로 더 쉽게 감지됩니다.
- YouTube는 인증된 세션(쿠키)이 없는 서버 요청을 차단합니다.
- 이 문제는 서버 구성 문제가 아니라 YouTube의 정책 문제입니다.

## 1. 필수 패키지 설치

```bash
# Python 3.10 및 필수 패키지 설치
python3.10 -m pip install --upgrade pip
python3.10 -m pip install -r requirements.txt

# PM2 설치 (Node.js가 필요)
npm install pm2 -g
```

## 2. YouTube 쿠키 설정 (필수)

**중요**: Fastcomet에 따르면, 이 작업은 서버에서 애플리케이션을 실행하기 위한 필수 조건입니다.

1. 로컬 컴퓨터에서 브라우저 확장 프로그램을 사용하여 YouTube 쿠키를 내보냅니다.
   - Chrome: [Get cookies.txt](https://chrome.google.com/webstore/detail/get-cookiestxt/bgaddhkoddajcdgocldbbfleckgcbcid)
   - Firefox: [Cookie Quick Manager](https://addons.mozilla.org/en-US/firefox/addon/cookie-quick-manager/)

2. YouTube에 로그인한 상태에서 쿠키를 내보내고 `youtube_cookies.txt`로 저장합니다.

3. FTP 또는 cPanel의 파일 관리자를 통해 이 파일을 서버의 애플리케이션 루트 디렉토리에 업로드합니다.

4. 파일 권한 설정:
   ```bash
   chmod 644 youtube_cookies.txt
   ```

5. 쿠키 파일이 유효한지 확인하세요. 쿠키는 일정 기간 후 만료되며, 오류가 발생하면 새로 생성해야 합니다.

## 3. SSL 인증서 문제 해결

SSL 인증서 검증 오류가 발생하는 경우:

1. 시스템 인증서 경로 확인:
   ```bash
   # Debian/Ubuntu
   ls -la /etc/ssl/certs/ca-certificates.crt

   # RHEL/CentOS
   ls -la /etc/pki/tls/certs/ca-bundle.crt

   # 다른 경로
   ls -la /etc/ssl/cert.pem
   ```

2. 환경 변수 설정:
   ```bash
   # 인증서 경로를 찾은 경우 해당 경로로 설정
   export SSL_CERT_FILE=/etc/ssl/certs/ca-certificates.crt
   export REQUESTS_CA_BUNDLE=/etc/ssl/certs/ca-certificates.crt
   ```

## 4. 서버 실행

### 방법 1: 직접 실행

```bash
# 실행 권한 부여
chmod +x run_server.sh

# 서버 실행
./run_server.sh
```

### 방법 2: PM2로 실행 (권장)

```bash
# PM2 설정 파일로 실행
pm2 start pm2_config.json

# 서버 상태 확인
pm2 status

# 로그 확인
pm2 logs YouTube-extractor

# 서버 재시작
pm2 restart YouTube-extractor

# 서버 중지
pm2 stop YouTube-extractor

# 시스템 재부팅 시 자동 시작 설정
pm2 startup
pm2 save
```

## 5. 문제 해결

### YouTube 봇 감지 문제 (가장 중요)

**Fastcomet의 설명에 따르면**:

1. 이 문제는 서버 구성 문제가 아니라 YouTube의 정책 문제입니다.
2. 서버 IP는 로컬 IP보다 봇으로 더 쉽게 감지됩니다.
3. 유효한 쿠키를 사용하는 것이 유일한 해결책입니다.

**해결 방법**:

1. 쿠키 파일이 최신 상태인지 확인하세요. 쿠키는 일정 기간 후 만료됩니다.
   ```bash
   # 쿠키 파일 내용 확인
   grep -v "^#" youtube_cookies.txt | wc -l
   ```

2. 요청 간 지연 시간을 늘려보세요:
   ```bash
   python3.10 app.py --sleep-requests 3 --min-sleep-interval 90 --max-sleep-interval 120
   ```

3. 로그를 확인하여 "Sign in to confirm you're not a bot" 오류가 발생하면 쿠키를 새로 생성하여 업로드하세요.

### SSL 인증서 오류가 발생하는 경우

1. Python SSL 인증서 업데이트:
   ```bash
   python3.10 -m pip install --upgrade certifi
   ```

2. 인증서 경로 설정:
   ```bash
   export SSL_CERT_FILE=/etc/ssl/certs/ca-certificates.crt
   export REQUESTS_CA_BUNDLE=/etc/ssl/certs/ca-certificates.crt
   ```

## 6. 보안 고려사항

1. 쿠키 파일에는 개인 정보가 포함되어 있으므로 안전하게 보관하세요.
2. 과도한 요청은 YouTube 계정이 제한될 수 있으므로 주의하세요.
3. 프로덕션 환경에서는 HTTPS를 사용하여 통신을 암호화하는 것이 좋습니다.
