# YouTube 쿠키 설정 가이드 (서버 환경용)

YouTube의 봇 방지 조치로 인해 서버에서 자막 추출 시 "Sign in to confirm you're not a bot" 오류가 발생합니다. 로컬에서는 작동하더라도 서버 환경에서는 YouTube가 더 엄격한 봇 방지 조치를 적용하기 때문에 반드시 쿠키 인증이 필요합니다.

## 로컬 vs 서버 환경 차이점

- **IP 감지**: 서버 IP는 YouTube에 의해 봇으로 더 쉽게 감지됩니다.
- **인증 요구**: 서버 요청에는 반드시 인증된 쿠키가 필요합니다.
- **요청 제한**: 서버에서는 더 엄격한 요청 제한이 적용될 수 있습니다.

## 쿠키 파일 생성 방법

### 1. 브라우저 확장 프로그램 사용 (권장)

1. 브라우저에 "Get cookies.txt" 또는 "Cookie-Editor" 확장 프로그램을 설치합니다.
   - Chrome: [Get cookies.txt](https://chrome.google.com/webstore/detail/get-cookiestxt/bgaddhkoddajcdgocldbbfleckgcbcid)
   - Firefox: [Cookie Quick Manager](https://addons.mozilla.org/en-US/firefox/addon/cookie-quick-manager/)

2. YouTube에 로그인합니다.

3. 확장 프로그램을 사용하여 YouTube 도메인의 쿠키를 Netscape 형식으로 내보냅니다.

4. 내보낸 쿠키 파일을 `youtube_cookies.txt`로 저장하고 애플리케이션 루트 디렉토리에 배치합니다.

### 2. yt-dlp 명령어 사용

yt-dlp는 브라우저에서 쿠키를 자동으로 가져올 수 있습니다:

```bash
yt-dlp --cookies-from-browser chrome > youtube_cookies.txt
```

또는:

```bash
yt-dlp --cookies-from-browser firefox > youtube_cookies.txt
```

## 주의사항

1. 쿠키 파일에는 개인 정보가 포함되어 있으므로 안전하게 보관하세요.
2. 쿠키는 일정 기간 후 만료될 수 있으므로 문제가 다시 발생하면 쿠키를 새로 생성해야 할 수 있습니다.
3. YouTube 계정이 봇으로 의심받아 제한될 가능성이 있으므로 과도한 요청은 피하세요.

## Fastcomet 서버에서 설정하기

### 1. 쿠키 파일 업로드

1. 로컬에서 생성한 `youtube_cookies.txt` 파일을 FTP 또는 cPanel의 파일 관리자를 통해 서버에 업로드합니다.

2. 파일 권한 설정:
   ```bash
   chmod 644 youtube_cookies.txt
   ```

### 2. 캐시 디렉토리 권한 설정

```bash
mkdir -p cache
chmod -R 755 cache
```

### 3. PM2를 사용하여 애플리케이션 실행

```bash
# PM2 설치 (이미 설치되어 있지 않은 경우)
npm install pm2 -g

# 애플리케이션 시작
pm2 start pm2_config.json

# 로그 확인
pm2 logs YouTube-extractor
```

### 4. 오류 발생 시 확인할 사항

1. 쿠키 파일이 유효한지 확인하세요. 쿠키는 일정 기간 후 만료되며, 만료 시 새로 생성해야 합니다.

2. 로그에서 "Sign in to confirm you're not a bot" 오류가 발생하면 쿠키를 새로 생성하여 업로드하세요.

3. 요청 사이의 지연 시간을 더 늘리는 것이 좋습니다. pm2_config.json 파일을 수정하여 다음 매개변수를 추가하세요:

```bash
--sleep-requests 3 --min-sleep-interval 60 --max-sleep-interval 120
```
